/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class HammerRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private static final List<HammerRecipe> recipeList = new ArrayList<HammerRecipe>();
    @Nonnull
    private final Map<Block, HammerRecipe> recipeByBlockCache = new HashMap<Block, HammerRecipe>();

    @Nonnull
    public List<ItemStackWithChance> getResult(@Nonnull Block input) {
        List<ItemStackWithChance> returnList = this.findRecipe(input).getOutput();
        logger.debug("Hammer Drop Stack: " + returnList);
        return returnList;
    }

    public boolean isHammerable(@Nonnull Block block) {
        return this.findRecipe(block) != HammerRecipe.EMPTY;
    }

    @Nonnull
    public HammerRecipe findRecipe(@Nonnull Block block) {
        return this.recipeByBlockCache.computeIfAbsent(block, k -> {
            ItemStack itemStack = new ItemStack((ItemLike)block);
            return recipeList.stream().filter(recipe -> recipe.getInput().test(itemStack)).findFirst().orElse(HammerRecipe.EMPTY);
        });
    }

    public void setRecipes(@Nonnull List<HammerRecipe> recipes) {
        logger.debug("Hammer Registry recipes: " + recipes.size());
        recipeList.addAll(recipes);
        this.recipeByBlockCache.clear();
    }

    @Nonnull
    public List<HammerRecipe> getRecipeList() {
        return recipeList;
    }

    public void clearRecipes() {
        recipeList.clear();
        this.recipeByBlockCache.clear();
    }
}

